@props([
    'merchant' => null,
    'showStats' => true,
    'showActions' => true,
    'compact' => false,
])

@if($merchant)
    <x-basics.card class="min-h-[100%] hover:shadow-lg transition-shadow duration-300">
        <x-slot name="action">
            {!! $merchant->getStatusBadge() !!}
        </x-slot>

        <div class="space-y-4">
            <!-- Merchant Header -->
            <div class="flex items-start space-x-4">
                <!-- Logo/Image Placeholder -->
                <div class="flex-shrink-0">
                    <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-purple-600 rounded-lg flex items-center justify-center">
                        <i class="ph ph-storefront text-white text-2xl"></i>
                    </div>
                </div>

                <!-- Merchant Info -->
                <div class="flex-1 min-w-0">
                    <h3 class="text-lg font-semibold text-gray-900 truncate">
                        {{ $merchant->name }}
                    </h3>
                    <p class="text-sm text-gray-500 mt-1">
                        <i class="ph ph-map-pin mr-1"></i>
                        {{ $merchant->address->city->name ?? 'N/A' }}, {{ $merchant->address->province->name ?? 'N/A' }}
                    </p>
                    <p class="text-sm text-gray-500 mt-1">
                        <i class="ph ph-phone mr-1"></i>
                        {{ $merchant->contact->phone ?? 'N/A' }}
                    </p>
                    @if($merchant->merchantType)
                        <div class="mt-2">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                <i class="ph ph-tag mr-1"></i>
                                {{ $merchant->merchantType->name }}
                            </span>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Merchant Description -->
            @if($merchant->description && !$compact)
                <div class="border-t border-gray-200 pt-4">
                    <p class="text-sm text-gray-600 leading-relaxed">
                        {{ Str::limit($merchant->description, 120) }}
                    </p>
                </div>
            @endif

            <!-- Stats Section -->
            @if($showStats && !$compact)
                <div class="border-t border-gray-200 pt-4">
                    <div class="grid grid-cols-2 gap-4">
                        <div class="text-center">
                            <div class="text-2xl font-bold text-blue-600">
                                {{ number_format($merchant->products()->count()) }}
                            </div>
                            <div class="text-xs text-gray-500">Produits</div>
                        </div>
                        <div class="text-center">
                            <div class="text-2xl font-bold text-green-600">
                                {{ number_format($merchant->sales()->count()) }}
                            </div>
                            <div class="text-xs text-gray-500">Ventes</div>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Quick Stats (Compact Mode) -->
            @if($showStats && $compact)
                <div class="flex justify-between text-sm">
                    <span class="text-gray-600">
                        <i class="ph ph-package mr-1"></i>
                        {{ $merchant->products()->count() }} produits
                    </span>
                    <span class="text-gray-600">
                        <i class="ph ph-shopping-cart mr-1"></i>
                        {{ $merchant->sales()->count() }} ventes
                    </span>
                </div>
            @endif

            <!-- Actions -->
            @if($showActions)
                <div class="border-t border-gray-200 pt-4">
                    <div class="flex space-x-2">
                        <x-basics.button-link 
                            href="{{ route('dashboard.merchants.show', $merchant) }}" 
                            class="flex-1 bg-blue-600 hover:bg-blue-700 text-white text-sm"
                            leftIcon="ph-eye"
                        >
                            Voir
                        </x-basics.button-link>
                        
                        @if($merchant->status == \App\Models\Merchant::STATUS_DRAFT)
                            <x-basics.button-link 
                                href="{{ route('dashboard.merchants.step1', $merchant) }}" 
                                class="flex-1 bg-gray-600 hover:bg-gray-700 text-white text-sm"
                                leftIcon="ph-pencil"
                            >
                                Modifier
                            </x-basics.button-link>
                        @endif
                    </div>
                </div>
            @endif

            <!-- Additional Info -->
            @if(!$compact)
                <div class="border-t border-gray-200 pt-4">
                    <div class="flex justify-between text-xs text-gray-500">
                        <span>
                            <i class="ph ph-calendar mr-1"></i>
                            Créé le {{ $merchant->created_at->format('d/m/Y') }}
                        </span>
                        @if($merchant->featured == \App\Models\Merchant::FEATURED_TRUE)
                            <span class="text-yellow-600">
                                <i class="ph ph-star-fill mr-1"></i>
                                Mis en avant
                            </span>
                        @endif
                    </div>
                </div>
            @endif
        </div>
    </x-basics.card>
@else
    <x-basics.card class="min-h-[100%]">
        <div class="text-center py-8">
            <i class="ph ph-storefront text-4xl text-gray-300 mb-4"></i>
            <p class="text-gray-500">Aucun établissement disponible</p>
        </div>
    </x-basics.card>
@endif 