@props(['location'])

<div x-data="{ showActivateModal: false, showDeactivateModal: false, showDeleteModal: false }">
    <x-basics.card title="Statut" subtitle="Statut général de l'emplacement">
    
        <x-slot name="action">
            <x-dashboard.locations.dropdown :location="$location" />
        </x-slot>
    
        <div class="space-y-3">
            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Statut général:</span>
                {!! $location->statusBadge !!}
            </div>

            @if($location->created_at)
            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Créé le:</span>
                <span class="text-sm">{{ $location->created_at->format('d M Y H:i') }}</span>
            </div>
            @endif

            @if($location->updated_at)
            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Modifié le:</span>
                <span class="text-sm">{{ $location->updated_at->format('d M Y H:i') }}</span>
            </div>
            @endif
        </div>
    
        <!-- Activate Location Modal -->
        <form action="{{ route('locations.activate', $location) }}" method="POST">
            @csrf
            @method('PUT')
            <x-basics.modal show="showActivateModal" title="Activer l'emplacement">
                <p class="text-gray-600">
                    Êtes-vous sûr de vouloir activer cet emplacement ?
                    L'emplacement <strong>{{ $location->name }}</strong> sera activé et sera disponible pour le stockage.
                </p>
                @slot('footer')
                    <div class="flex justify-end gap-3">
                        <x-basics.button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white">
                            Activer l'emplacement
                        </x-basics.button>
                    </div>
                @endslot
            </x-basics.modal>
        </form>
    
        <!-- Deactivate Location Modal -->
        <form action="{{ route('locations.deactivate', $location) }}" method="POST">
            @csrf
            @method('PUT')
            <x-basics.modal show="showDeactivateModal" title="Désactiver l'emplacement" description="">
                <p class="text-gray-600">
                    Êtes-vous sûr de vouloir désactiver cet emplacement ?
                    L'emplacement <strong>{{ $location->name }}</strong> sera désactivé et ne sera plus disponible pour le stockage.
                </p>
                @slot('footer')
                    <div class="flex justify-end gap-3">
                        <x-basics.button type="submit" class="w-full bg-red-600 hover:bg-red-700 text-white">
                            Désactiver l'emplacement
                        </x-basics.button>
                    </div>
                @endslot
            </x-basics.modal>
        </form>

        <!-- Delete Location Modal -->
        <form action="{{ route('locations.destroy', $location) }}" method="POST">
            @csrf
            @method('DELETE')
            <x-basics.modal show="showDeleteModal" title="Supprimer l'emplacement" description="">
                <div class="text-gray-600">
                    Êtes-vous sûr de vouloir supprimer cet emplacement ?
                    <p class="mb-2">
                        L'emplacement <strong>{{ $location->name }}</strong> sera supprimé définitivement.
                    </p>
                    <p class="text-sm text-red-600">
                        Cette action est irréversible. Assurez-vous qu'aucun produit n'est stocké dans cet emplacement.
                    </p>
                </div>
                @slot('footer')
                    <div class="flex justify-end gap-3">
                        <x-basics.button type="submit" class="w-full bg-red-600 hover:bg-red-700 text-white">
                            Supprimer l'emplacement
                        </x-basics.button>
                    </div>
                @endslot
            </x-basics.modal>
        </form>
    
    </x-basics.card>
</div>
