@props(['expenseCategory'])

<div class="space-y-6">
    <x-basics.card title="Statut" subtitle="Informations sur la catégorie">
        <div class="space-y-4">
            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Statut:</span>
                <span class="text-sm font-medium">{!! $expenseCategory->getStatusBadge() !!}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Date de création:</span>
                <span class="text-sm font-medium">
                    {{ $expenseCategory->created_at->format('d/m/Y') }}
                </span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Date de mise à jour:</span>
                <span class="text-sm font-medium">
                    {{ $expenseCategory->updated_at->format('d/m/Y') }}
                </span>
            </div>
        </div>
    </x-basics.card>

    <x-basics.card title="Conseils" subtitle="Bonnes pratiques" bodyBg="bg-blue-50">
        <div class="space-y-3 text-sm">
            <p class="text-gray-600 text-justify">
                <strong>· Organisation</strong> : Créez des catégories logiques comme "Fournitures de bureau", "Maintenance", 
                "Marketing", "Transport", etc.
            </p>
            
            <p class="text-gray-600 text-justify">
                <strong>· Prudence</strong> : Une fois qu'une catégorie contient des dépenses, elle ne peut plus être supprimée 
                pour préserver l'intégrité des données.
            </p>
            
            <p class="text-gray-600 text-justify">
                <strong>· Statut</strong> : Les catégories inactives ne peuvent pas recevoir de nouvelles dépenses.
            </p>
        </div>
    </x-basics.card>

</div>
