@props(['debt' => null])

<div class="space-y-6">
    @if($debt)
        <!-- Debt Status -->
        <x-basics.card title="Statut de la Dette">
            <div class="space-y-3 text-sm">
                <div class="flex items-center justify-between">
                    <span class="text-gray-600">Statut:</span>
                    {!! $debt->getStatusBadge() !!}
                </div>

                <div class="flex items-center justify-between">
                    <span class="text-gray-600">Date de création:</span>
                    <span class="font-medium">{{ $debt->created_at->format('d/m/Y H:i') }}</span>
                </div>

                @if ($debt->due_date)
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Date d'échéance:</span>
                        <span class="font-medium {{ $debt->isOverdue() ? 'text-red-600' : '' }}">
                            {{ $debt->due_date->format('d/m/Y') }}
                            @if ($debt->isOverdue())
                                <br><span class="text-xs text-red-500">
                                    {{ abs($debt->days_until_due) }} jour{{ abs($debt->days_until_due) > 1 ? 's' : '' }} de retard
                                </span>
                            @endif
                        </span>
                    </div>
                @endif

                <div class="border-t pt-3">
                    <div class="flex items-center justify-between">
                        <span class="font-bold text-gray-900">Montant total:</span>
                        <span class="font-bold text-gray-900">{{ $debt->formatted_total_debt_amount }}</span>
                    </div>
                </div>

                <div class="flex items-center justify-between">
                    <span class="text-gray-600">Montant payé:</span>
                    <span class="font-medium text-green-600">{{ $debt->formatted_paid_amount }}</span>
                </div>

                <div class="flex items-center justify-between">
                    <span class="text-gray-600">Montant restant:</span>
                    <span class="font-medium text-red-600">{{ $debt->formatted_remaining_amount }}</span>
                </div>

                @if ($debt->payments->count() > 0)
                    <div class="flex items-center justify-between">
                        <span class="text-gray-600">Paiements:</span>
                        <span class="font-medium">{{ $debt->payments->count() }}</span>
                    </div>
                @endif
            </div>
        </x-basics.card>
    @endif

    <!-- Debt Management -->
    <x-basics.card title="Gestion des Dettes" bodyBg="bg-orange-50">
        <div class="space-y-3 text-sm">
            <div class="flex items-center space-x-2">
                <i class="ph ph-credit-card text-blue-600"></i>
                <span class="text-gray-600">Suivi des paiements</span>
            </div>
            <div class="flex items-center space-x-2">
                <i class="ph ph-calendar text-green-600"></i>
                <span class="text-gray-600">Gestion des échéances</span>
            </div>
            <div class="flex items-center space-x-2">
                <i class="ph ph-warning text-red-600"></i>
                <span class="text-gray-600">Alertes de retard</span>
            </div>
            <div class="flex items-center space-x-2">
                <i class="ph ph-chart-line text-purple-600"></i>
                <span class="text-gray-600">Analyse des créances</span>
            </div>
        </div>
    </x-basics.card>

    <!-- Tips -->
    <x-basics.card title="Conseils d'Utilisation" bodyBg="bg-yellow-50">
        <div class="space-y-3 text-sm">
            <p class="text-gray-600 text-justify">
                <strong>Suivi régulier :</strong> Vérifiez régulièrement les dettes en attente pour maintenir
                un bon suivi des créances clients et éviter les retards de paiement.
            </p>
            <p class="text-gray-600 text-justify">
                <strong>Échéances :</strong> Définissez des dates d'échéance réalistes pour permettre
                aux clients de planifier leurs paiements et améliorer le taux de recouvrement.
            </p>
            <p class="text-gray-600 text-justify">
                <strong>Communication :</strong> Maintenez une communication claire avec les clients
                concernant les montants dus et les échéances pour faciliter le recouvrement.
            </p>
        </div>
    </x-basics.card>
    
</div>
