@props(['debt'])

@php
    $paymentMethodOptions = collect(\App\Models\DebtPayment::PAYMENT_METHODS)->map(function ($method) {
        return (object) $method;
    });
@endphp

<div x-data="{ showPaymentModal{{ $debt->id }}: false }">
    <x-basics.button :x-on:click="'showPaymentModal{{ $debt->id }} = true'" variant="primary" size="sm">
        <i class="ph ph-money mr-1"></i>
        Payer
    </x-basics.button>

    <form action="{{ route('debts.collect', $debt) }}" method="POST">
        @csrf
        <x-basics.modal :show="'showPaymentModal{{ $debt->id }}'" title="Enregistrer un Paiement" 
            :description="'Paiement pour la vente ' . $debt->sale->sale_number">
            
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Montant restant</label>
                    <div class="text-lg font-semibold text-red-600">
                        {{ number_format($debt->remaining_amount, 0, ',', ' ') }}
                        {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                    </div>
                </div>

                <div>
                    <x-basics.input name="amount" label="Montant à payer" type="number" 
                        step="0.01" min="0.01" max="{{ $debt->remaining_amount }}" 
                        required />
                </div>

                <div>
                    <x-basics.select name="payment_method" label="Méthode de paiement" required
                        :options="$paymentMethodOptions" />
                </div>

                <div>
                    <x-basics.input name="payment_date" label="Date de paiement" type="date" 
                        value="{{ now()->format('Y-m-d') }}" required />
                </div>

                <div>
                    <x-basics.input name="reference" label="Référence (optionnel)" 
                        placeholder="Numéro de transaction..." />
                </div>

                <div>
                    <x-basics.textarea name="notes" label="Notes (optionnel)" 
                        rows="3" placeholder="Notes sur le paiement..." />
                </div>
            </div>

            @slot('footer')
                <div class="flex gap-2">
                    <x-basics.button type="submit" class="flex-1">
                        <i class="ph ph-money mr-2"></i>
                        Enregistrer le paiement
                    </x-basics.button>
                    <x-basics.button type="button" :x-on:click="'showPaymentModal{{ $debt->id }} = false'" variant="outline">
                        Annuler
                    </x-basics.button>
                </div>
            @endslot
        </x-basics.modal>
    </form>
</div>

