@props(['customer'])

<div class="space-y-6">
    <x-basics.card title="Statistiques" subtitle="Informations sur le client">
        <div class="space-y-3">
            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Client depuis:</span>
                <span class="text-sm font-medium">{{ $customer->created_at->format('d/m/Y') }}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Total des ventes:</span>
                <span class="text-sm font-medium">{{ $customer->sales->count() }}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Montant total:</span>
                <span class="text-sm font-medium">{{ number_format($customer->sales->sum('total_amount'), 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">Statut:</span>
                {!! $customer->getStatusBadge() !!}
            </div>
        </div>
    </x-basics.card>

    <!-- Customer Overview -->
    <x-basics.card title="À propos des Clients" bodyBg="bg-blue-50">
        <div class="space-y-4 text-sm text-gray-700">
            <div class="flex items-start space-x-3">
                <i class="ph ph-users text-blue-600 mt-1"></i>
                <div>
                    <p class="font-medium text-gray-800">Gestion centralisée</p>
                    <p class="text-gray-600 mt-1">Centralisez toutes les informations de vos clients : coordonnées, historique d'achats et statuts.</p>
                </div>
            </div>
            
            <div class="flex items-start space-x-3">
                <i class="ph ph-chart-line text-green-600 mt-1"></i>
                <div>
                    <p class="font-medium text-gray-800">Suivi personnalisé</p>
                    <p class="text-gray-600 mt-1">Analysez les préférences et habitudes d'achat pour améliorer votre service client.</p>
                </div>
            </div>
        </div>
    </x-basics.card>

    <!-- Customer Management -->
    <x-basics.card title="Gestion des Clients" bodyBg="bg-green-50">
        <div class="space-y-4 text-sm text-gray-700">
            <div class="flex items-start space-x-3">
                <i class="ph ph-user-plus text-green-600 mt-1"></i>
                <div>
                    <p class="font-medium text-gray-800">Profils complets</p>
                    <p class="text-gray-600 mt-1">Créez des profils détaillés avec contact, adresse et notes personnalisées.</p>
                </div>
            </div>
            
            <div class="flex items-start space-x-3">
                <i class="ph ph-credit-card text-blue-600 mt-1"></i>
                <div>
                    <p class="font-medium text-gray-800">Gestion des dettes</p>
                    <p class="text-gray-600 mt-1">Suivez les dettes, paiements et limites de crédit pour une comptabilité saine.</p>
                </div>
            </div>
        </div>
    </x-basics.card>

</div>
