@props(['category'])

<div x-data="{ showDeleteModal: false }">
    <x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
        <x-slot name="trigger">
            <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
                <i class="ph ph-dots-three-outline-vertical text-xl"></i>
            </button>
        </x-slot>

        <x-slot name="content">
            <x-basics.dropdown-item icon="ph ph-eye" href="{{ route('categories.show', $category) }}">
                Voir
            </x-basics.dropdown-item>

            <x-basics.dropdown-item icon="ph ph-pencil" href="{{ route('categories.edit', $category) }}">
                Modifier
            </x-basics.dropdown-item>

            @if (($category->products?->count() ?? 0) === 0)
                <x-basics.dropdown-separator />
                <x-basics.dropdown-item icon="ph ph-trash" variant="danger" @click="showDeleteModal = true">
                    Supprimer
                </x-basics.dropdown-item>
            @endif
        </x-slot>
    </x-basics.dropdown>

    <!-- Delete Modal -->
    <form method="POST" action="{{ route('categories.destroy', $category) }}" class="inline">
        @csrf
        @method('DELETE')
        <x-basics.modal show="showDeleteModal" title="Supprimer la catégorie"
            description="Confirmer la suppression de la catégorie">
            <p>Voulez-vous vraiment supprimer cette catégorie ?</p>
            <p class="text-sm text-red-500 mt-2">Cette action est irréversible.</p>
            @slot('footer')
                <x-basics.button type="submit" variant="danger" class="w-full">
                    <i class="ph ph-trash mr-2"></i>
                    Supprimer
                </x-basics.button>
            @endslot
        </x-basics.modal>
    </form>

</div>
