@props(['user'])

<div class="space-y-6">
    <!-- About Activity Logs -->
    <x-basics.card title="À propos des Activités" bodyBg="bg-blue-50">
        <div class="space-y-3 text-sm">
            <p class="text-gray-600 text-justify">
                Cette page affiche un historique détaillé de toutes les actions effectuées sur votre compte.
                Cela inclut les connexions, les modifications de profil, les changements de mot de passe,
                et d'autres interactions importantes avec le système.
            </p>
            <p class="text-gray-600 text-justify">
                Chaque activité est horodatée et enregistre des informations telles que l'adresse IP,
                le navigateur utilisé et le type d'action.
            </p>
        </div>
    </x-basics.card>

    <!-- Privacy and Security -->
    <x-basics.card title="Confidentialité et Sécurité" bodyBg="bg-yellow-50">
        <div class="space-y-3 text-sm">
            <p class="text-gray-600 text-justify">
                La journalisation des activités est essentielle pour la sécurité de votre compte.
                Elle permet de détecter toute activité suspecte ou non autorisée.
            </p>
            <p class="text-gray-600 text-justify">
                Si vous remarquez une activité que vous ne reconnaissez pas, veuillez changer votre mot de passe
                immédiatement et contacter le support technique.
            </p>
        </div>
    </x-basics.card>

    <!-- Activity Types -->
    <x-basics.card title="Types d'Activités" bodyBg="bg-green-50">
        <div class="space-y-3 text-sm">
            <div class="flex items-center space-x-2">
                <i class="ph ph-sign-in text-blue-600"></i>
                <span class="text-gray-600">Connexions et déconnexions</span>
            </div>
            <div class="flex items-center space-x-2">
                <i class="ph ph-user-circle text-green-600"></i>
                <span class="text-gray-600">Modifications de profil</span>
            </div>
            <div class="flex items-center space-x-2">
                <i class="ph ph-lock text-orange-600"></i>
                <span class="text-gray-600">Changements de mot de passe</span>
            </div>
            <div class="flex items-center space-x-2">
                <i class="ph ph-eye text-purple-600"></i>
                <span class="text-gray-600">Consultations de données</span>
            </div>
            <div class="flex items-center space-x-2">
                <i class="ph ph-pencil text-red-600"></i>
                <span class="text-gray-600">Modifications de données</span>
            </div>
        </div>
    </x-basics.card>
</div>
