@props(['activity'])

<div class="flex items-start space-x-3 p-3 bg-gray-50 rounded-lg">
    <div class="flex-shrink-0">
        <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center">
            <i class="{{ $activity->action_icon }} text-blue-600 text-sm"></i>
        </div>
    </div>
    
    <div class="flex-1 min-w-0">
        <div class="flex items-center justify-between">
            <p class="text-sm font-medium text-gray-900">
                {{ $activity->description }}
            </p>
            <div class="flex items-center space-x-2">
                {!! $activity->severity_badge !!}
            </div>
        </div>
        
        <div class="mt-1 flex items-center space-x-4 text-xs text-gray-500">
            <span class="flex items-center">
                <i class="ph ph-clock mr-1"></i>
                {{ $activity->created_at->diffForHumans() }}
            </span>
            
            @if($activity->ip_address)
                <span class="flex items-center">
                    <i class="ph ph-globe mr-1"></i>
                    {{ $activity->ip_address }}
                </span>
            @endif
            
            @if($activity->url)
                <span class="flex items-center">
                    <i class="ph ph-link mr-1"></i>
                    {{ parse_url($activity->url, PHP_URL_PATH) }}
                </span>
            @endif
        </div>
        
        @if($activity->model_type && $activity->model)
            <div class="mt-2">
                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                    <i class="ph ph-package mr-1"></i>
                    {{ class_basename($activity->model_type) }} #{{ $activity->model_id }}
                </span>
            </div>
        @endif
    </div>
</div>