@props(['user'])

<x-basics.dropdown align="right" width="w-56" :closeOnClick="true">
    <x-slot name="trigger">
        <button type="button" class="p-2 rounded hover:bg-gray-100" aria-label="Open menu">
            <i class="ph ph-dots-three-outline-vertical text-xl"></i>
        </button>
    </x-slot>

    <x-slot name="content">
        <!-- Account Actions -->
        <x-basics.dropdown-item icon="ph ph-user" href="{{ route('account.index') }}" wire:navigate>
            Voir le compte
        </x-basics.dropdown-item>

        <!-- Account Actions -->
        <x-basics.dropdown-item icon="ph ph-user-circle" href="{{ route('account.edit') }}" wire:navigate>
            Modifier le profil
        </x-basics.dropdown-item>

        <!-- Account Actions -->
        <x-basics.dropdown-item icon="ph ph-lock" href="{{ route('account.password') }}" wire:navigate>
            Changer le mot de passe
        </x-basics.dropdown-item>

        <x-basics.dropdown-separator />
        <!-- Logout -->
        <form method="POST" action="{{ route('logout') }}" class="w-full">
            @csrf
            <x-basics.dropdown-item icon="ph ph-sign-out" variant="danger" href="#"
                onclick="event.preventDefault(); this.closest('form').submit();">
                Se déconnecter
            </x-basics.dropdown-item>
        </form>
    </x-slot>
</x-basics.dropdown>
