import './bootstrap';

// Handle 419 CSRF token mismatch errors globally
document.addEventListener('DOMContentLoaded', function() {
    // Handle Livewire 419 errors
    if (window.Livewire) {
        window.Livewire.hook('request', ({ fail }) => {
            if (fail && fail.status === 419) {
                // Show user-friendly message
                // alert('Your session has expired. You will be redirected to the login page.');
                // Redirect to login
                window.location.href = '/login';
            }
        });
    }

    // Handle fetch/axios 419 errors
    const originalFetch = window.fetch;
    window.fetch = function(...args) {
        return originalFetch.apply(this, args).then(response => {
            if (response.status === 419) {
                // alert('Your session has expired. You will be redirected to the login page.');
                window.location.href = '/login';
                return Promise.reject(new Error('Session expired'));
            }
            return response;
        });
    };
});
