<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prescriptions', function (Blueprint $table) {
            $table->id();

            // Fields from index API response
            $table->string('reference')->nullable()->unique();
            $table->string('customer_name')->nullable();
            $table->integer('products_count')->default(0);
            $table->enum('status', ['En attente', 'Approuvé', 'Rejeté', 'Terminé', 'Annulé', 'Brouillon'])->default('En attente');
            $table->datetime('created_at')->nullable();
            $table->decimal('distance', 8, 2)->nullable();

            // Additional fields for show page (will be populated later)
            $table->string('customer_slug')->nullable();
            $table->string('conversation_slug')->nullable();
            $table->json('products')->nullable();
            $table->json('notes')->nullable();

            $table->index('status');
            $table->index(['created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prescriptions');
    }
};
