<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->integer('api_id')->nullable();
            $table->string('slug')->unique();
            $table->string('category');
            $table->string('code', 15);
            $table->date('start_date');
            $table->date('end_date');
            $table->integer('duration_in_days');
            $table->string('status')->default('active');
            $table->timestamp('activated_at')->nullable();
            $table->timestamps();
            $table->index('slug');
            $table->index('api_id');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};
