<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();

            // Merchant Information
            $table->string('merchant_name')->default('My Pharmacy');
            $table->string('merchant_code')->unique()->nullable();
            $table->string('merchant_slug')->unique()->nullable();
            $table->string('merchant_slogan')->nullable();
            $table->string('merchant_cnop')->nullable();

            // Merchant Location
            $table->foreignId('merchant_province_id')->nullable()->constrained('provinces')->onDelete('set null');
            $table->foreignId('merchant_city_id')->nullable()->constrained('cities')->onDelete('set null');
            $table->decimal('merchant_latitude', 10, 8)->nullable(); // 10 digits total, 8 after decimal
            $table->decimal('merchant_longitude', 11, 8)->nullable(); // 11 digits total, 8 after decimal

            // Merchant Contact
            $table->string('merchant_phone')->nullable();
            $table->string('merchant_email')->nullable();
            $table->text('merchant_address')->nullable();

            // Merchant Type
            $table->string('merchant_type')->default('pharmacie');

            // Merchant Status
            $table->boolean('merchant_status')->default(false); 
            
            $table->string('merchant_created_at')->nullable();

            // Bootstrap Completed
            $table->boolean('bootstrap_completed')->default(false);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
