<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('inventory_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // Who made the transaction
            $table->enum('transaction_type', ['purchase', 'sale', 'adjustment', 'expiry', 'damage', 'return'])->default('sale');
            $table->integer('quantity');
            $table->integer('quantity_before');
            $table->integer('quantity_after');
            $table->decimal('unit_cost', 10, 2)->nullable();
            $table->decimal('total_cost', 10, 2)->nullable();
            $table->string('reference_number')->nullable(); // Sale number, purchase order, etc.
            $table->text('notes')->nullable();
            $table->timestamps();
            
            $table->index(['product_id', 'transaction_type']);
            $table->index(['created_at']);
            $table->index(['reference_number']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inventory_transactions');
    }
}; 