<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('merchant_users', function (Blueprint $table) {
            $table->id();

            // Relations
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();

            $table->enum('role', ['owner', 'admin', 'cashier', 'stock_agent']);
            $table->boolean('status')->default(false); // can be used to suspend users
            $table->timestamp('joined_at')->nullable();  // when user accepted invite

            $table->timestamps();
            $table->unique('user_id'); // prevent duplicates
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('merchant_users');
    }
};
