<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Prescription extends Model
{
    use HasFactory;

    protected $guarded = [];

    public $timestamps = false;

    const STATUS_PENDING = 'pending';
    const STATUS_APPROVED = 'approved';
    const STATUS_REJECTED = 'rejected';
    const STATUS_COMPLETED = 'completed';
    const STATUS_CANCELLED = 'cancelled';
    const STATUS_DRAFT = 'draft';

    protected $casts = [
        'products' => 'array',
        'notes' => 'array',
        'created_at' => 'datetime',
    ];

    public static function getStatusBadge($status)
    {
        return match ($status) {
            'En attente' => '<span class="inline-flex items-center px-2.5 py-0.5 rounded text-xs font-medium bg-yellow-100 text-yellow-800 border border-yellow-500 min-w-30 justify-center"><i class="ph ph-clock mr-1"></i>En attente</span>',
            'Approuvé' => '<span class="inline-flex items-center px-2.5 py-0.5 rounded text-xs font-medium bg-green-100 text-green-800 border border-green-500 min-w-30 justify-center"><i class="ph ph-check-circle mr-1"></i>Approuvé</span>',
            'Rejeté' => '<span class="inline-flex items-center px-2.5 py-0.5 rounded text-xs font-medium bg-red-100 text-red-800 border border-red-500 min-w-30 justify-center"><i class="ph ph-x-circle mr-1"></i>Rejeté</span>',
            'Terminé' => '<span class="inline-flex items-center px-2.5 py-0.5 rounded text-xs font-medium bg-blue-100 text-blue-800 border border-blue-500 min-w-30 justify-center"><i class="ph ph-check-circle mr-1"></i>Terminé</span>',
            'Annulé' => '<span class="inline-flex items-center px-2.5 py-0.5 rounded text-xs font-medium bg-gray-100 text-gray-800 border border-gray-500 min-w-30 justify-center"><i class="ph ph-x-circle mr-1"></i>Annulé</span>',
            'Brouillon' => '<span class="inline-flex items-center px-2.5 py-0.5 rounded text-xs font-medium bg-gray-100 text-gray-800 border border-gray-500 min-w-30 justify-center"><i class="ph ph-clock mr-1"></i>Brouillon</span>',
            default => '<span class="inline-flex items-center px-2.5 py-0.5 rounded text-xs font-medium bg-gray-100 text-gray-800 border border-gray-500 min-w-30 justify-center"><i class="ph ph-x-circle mr-1"></i>Inconnu</span>',
        };
    }

    public static function getStatusName($status)
    {
        return match ($status) {
            'En attente' => 'En attente',
            'Approuvé' => 'Approuvé',
            'Rejeté' => 'Rejeté',
            'Terminé' => 'Terminé',
            'Annulé' => 'Annulé',
            'Brouillon' => 'Brouillon',
            default => 'Inconnu',
        };
    }
}
