<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ConversationMessage extends Model
{
    protected $fillable = [
        'conversation_id',
        'api_message_id',
        'sender_type',
        'user_id',
        'merchant_id',
        'body',
        'api_created_at',
    ];

    protected $casts = [
        'api_created_at' => 'datetime',
    ];

    /**
     * Get the conversation that owns the message.
     */
    public function conversation(): BelongsTo
    {
        return $this->belongsTo(Conversation::class);
    }

    /**
     * Check if message is from merchant.
     */
    public function isFromMerchant(): bool
    {
        return $this->sender_type === 'merchant';
    }

    /**
     * Check if message is from user.
     */
    public function isFromUser(): bool
    {
        return $this->sender_type === 'user';
    }
}
