<?php

namespace App\Livewire\Users;

use App\Models\ActivityLog;
use App\Models\User;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;

#[Layout('layouts.dashboard')]
class Activities extends Component
{
    use WithPagination;

    protected string $paginationTheme = 'tailwind';

    public User $user;

    public function mount(User $user): void
    {
        $this->user = $user;
    }

    public function render(): \Illuminate\Contracts\View\View
    {
        $activities = ActivityLog::query()
            ->where('user_id', $this->user->id)
            ->orderByDesc('created_at')
            ->paginate(25);

        return view('livewire.users.activities', compact('activities'));
    }
}


