<?php

namespace App\Livewire\Suppliers;

use App\Models\Supplier;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.dashboard')]
class Show extends Component
{
    public Supplier $supplier;

    public function mount(Supplier $supplier): void
    {
        $this->supplier = $supplier->load(['purchaseOrders', 'stockEntries']);
    }

    public function render(): \Illuminate\Contracts\View\View
    {
        return view('livewire.suppliers.show');
    }
}
