<?php

namespace App\Livewire\Subscriptions;

use Livewire\Component;
use Livewire\Attributes\Layout;
use App\Models\Subscription;
use Livewire\WithPagination;

#[Layout('layouts.dashboard')]
class Index extends Component
{
    use WithPagination;

    protected string $paginationTheme = 'tailwind';
    /**
     * Subscriptions data
     * @var \Illuminate\Pagination\LengthAwarePaginator
     */

    /**
     * Render the component
     * @return \Illuminate\Contracts\View\View
     */
    public function render(): \Illuminate\Contracts\View\View
    {
        $subscriptions = Subscription::orderBy('created_at', 'desc')->paginate(25);
        return view('livewire.subscriptions.index', compact('subscriptions'));
    }
}
