<?php

namespace App\Livewire\StockAdjustments;

use App\Models\StockAdjustment;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.dashboard')]
class Show extends Component
{
    public StockAdjustment $adjustment;

    public function mount(StockAdjustment $stockAdjustment): void
    {
        $this->adjustment = $stockAdjustment->load(['items.product', 'user']);
    }

    public function render(): \Illuminate\Contracts\View\View
    {
        return view('livewire.stock-adjustments.show');
    }
}
