<?php

namespace App\Livewire\Sales;

use App\Models\Sale;
use Livewire\Component;
use Livewire\Attributes\Layout;

#[Layout('layouts.dashboard')]
class Show extends Component
{
    public Sale $sale;

    public function mount(Sale $sale)
    {
        $this->sale = $sale->load(['customer', 'paymentMethod', 'saleType', 'user', 'items.product']);
    }

    public function render(): \Illuminate\Contracts\View\View
    {
        return view('livewire.sales.show');
    }
}
