<?php

namespace App\Livewire\SaleTypes;

use App\Models\SaleType;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;

#[Layout('layouts.dashboard')]
class Index extends Component
{
    use WithPagination;

    protected string $paginationTheme = 'tailwind';

    public bool $showCreateModal = false;

    public string $name = '';

    public bool $success = false;

    public bool $error = false;

    public ?string $successMessage = null;

    public ?string $errorMessage = null;

    public function openCreateModal(): void
    {
        $this->showCreateModal = true;
        $this->reset(['name', 'success', 'error', 'successMessage', 'errorMessage']);
    }

    public function closeCreateModal(): void
    {
        $this->showCreateModal = false;
        $this->reset(['name']);
    }

    public function render(): \Illuminate\Contracts\View\View
    {
        $saleTypes = SaleType::orderBy('created_at', 'desc')->paginate(25);

        return view('livewire.sale-types.index', compact('saleTypes'));
    }
}
