<?php

namespace App\Livewire\Products;

use Livewire\Component;
use Livewire\Attributes\Layout;
use App\Models\Product;

#[Layout('layouts.dashboard')]
class Show extends Component
{
    /**
     * Product data
     * @var Product
     */
    public $product;

    /**
     * Initialize component data
     * @param Product $product
     * @return void
     */
    public function mount(Product $product): void
    {
        $this->product = $product;
    }

    /**
     * Render the component
     * @return \Illuminate\Contracts\View\View
     */
    public function render(): \Illuminate\Contracts\View\View
    {
        return view('livewire.products.show');
    }
}
