<?php

namespace App\Livewire\Merchant;

use Livewire\Component;

class ModalDeactivate extends Component
{
    public bool $error = false;

    public string $error_message = '';

    public bool $deactivating = false;

    public function deactivate(): void
    {
        $this->deactivating = true;
        $this->error = false;
        $this->error_message = '';

        $result = deactivateMerchant();

        if (! $result['success']) {
            $this->error = true;
            $this->error_message = $result['message'] ?? 'Échec de la désactivation';
            $this->deactivating = false;

            return;
        }

        $this->deactivating = false;
        session()->flash('success', 'Établissement désactivé avec succès.');
        $this->dispatch('merchant-deactivated');
        $this->dispatch('close-modal');
    }

    public function render()
    {
        return view('livewire.merchant.modal-deactivate');
    }
}
