<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\Attributes\Layout;

#[Layout('layouts.dashboard')]
class Home extends Component
{
    /**
     * Dashboard statistics
     * @var array
     */
    public array $stats = [];

    /**
     * Weekly financial chart data
     * @var array
     */
    public array $weeklyFinancialChart = [];

    /**
     * Payment methods chart data
     * @var array
     */
    public array $paymentMethodsChart = [];

    /**
     * Recent sales data
     * @var \Illuminate\Database\Eloquent\Collection
     */
    public $recentSales;

    /**
     * Top products data
     * @var \Illuminate\Database\Eloquent\Collection
     */
    public $topProducts;

    /**
     * Recent prescriptions data
     * @var \Illuminate\Database\Eloquent\Collection
     */
    public $recentPrescriptions;

    /**
     * Merchant active status
     * @var bool
     */
    public bool $isMerchantActive = false;


    /**
     * Initialize component data
     * @return void
     */
    public function mount(): void
    {
        // dd(\Illuminate\Support\Facades\Auth::user());

        $result = getAndSyncMerchant();
        

        // Check if we're in offline mode or if sync failed
        $isOfflineMode = $result['offline_mode'] ?? false;
        $syncFailed = !$result['success'];

        // If sync failed but we have local merchant data, continue in offline mode
        if ($syncFailed) {
            $settings = settings();
            if ($settings && !empty($settings['merchant_name'])) {
                // We have local data, continue in offline mode
                if($settings['merchant_status'] == \App\Models\Merchant::STATUS_DRAFT){
                    $isOfflineMode = true;
                    session()->flash('warning', 'Votre établissement n\'a pas encore été activé.');
                }elseif($settings['merchant_status'] == \App\Models\Merchant::STATUS_SUSPENDED){
                    $isOfflineMode = true;
                    session()->flash('warning', 'Votre établissement a été suspendu.');
                }
                else{
                    $isOfflineMode = true;
                    session()->flash('warning', 'Mode hors ligne activé');
                }
            } else {
                // No local data and API failed, redirect to merchant setup
                $this->redirect(route('merchant.show'), navigate: true);
                return;
            }
        }

        // Show offline mode warning if applicable
        if ($isOfflineMode && !$syncFailed) {
            session()->flash('warning', $result['message'] ?? 'Mode hors ligne activé');
        }

        $this->isMerchantActive = isMerchantActive();

        // Load data only if merchant is active
        if ($this->isMerchantActive) {
            $this->stats = getStats();
            $this->weeklyFinancialChart = getWeeklyFinancialChart();
            $this->paymentMethodsChart = getPaymentMethodsChart();
            $this->recentSales = getRecentSales();
            $this->topProducts = getTopProducts();
            $this->recentPrescriptions = getRecentPrescriptions();
        }
    }

    /**
     * Render the component
     * @return \Illuminate\Contracts\View\View
     */
    public function render(): \Illuminate\Contracts\View\View
    {
        return view('livewire.home');
    }
}
