<?php

namespace App\Livewire\Expenses;

use App\Models\Expense;
use Livewire\Component;
use Livewire\Attributes\Layout;

#[Layout('layouts.dashboard')]
class Show extends Component
{
    public Expense $expense;

    public function mount(Expense $expense): void
    {
        $this->expense = $expense->load(['category', 'user']);
    }

    public function render(): \Illuminate\Contracts\View\View
    {
        return view('livewire.expenses.show');
    }
}
