<?php

namespace App\Livewire\ExpenseCategories;

use App\Models\ExpenseCategory;
use Livewire\Component;
use Livewire\Attributes\Layout;
use Livewire\WithPagination;

#[Layout('layouts.dashboard')]
class Index extends Component
{
    use WithPagination;

    protected string $paginationTheme = 'tailwind';

    public function render(): \Illuminate\Contracts\View\View
    {
        $categories = ExpenseCategory::query()
            ->withCount('expenses')
            ->when(request('search'), function ($query) {
                $query->where('name', 'like', '%'.request('search').'%');
            })
            ->when(request('status'), function ($query) {
                $query->where('status', request('status'));
            })
            ->orderByDesc('created_at')
            ->paginate(25);

        $statuses = collect([
            (object) ['value' => '', 'label' => 'Tous'],
            (object) ['value' => '1', 'label' => 'Actif'],
            (object) ['value' => '0', 'label' => 'Inactif'],
        ]);

        return view('livewire.expense-categories.index', [
            'categories' => $categories,
            'statuses' => $statuses,
        ]);
    }
}
