<?php

namespace App\Livewire\Debts;

use App\Models\Debt;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.dashboard')]
class Show extends Component
{
    public Debt $debt;

    public function mount(Debt $debt)
    {
        // Ensure debt belongs to current merchant
        // No merchant filtering needed for single-tenant app
        
        $this->debt = $debt->load(['customer', 'sale', 'payments.user']);
    }

    public function render(): \Illuminate\Contracts\View\View
    {
        return view('livewire.debts.show');
    }
}
