<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckAppLicensed
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Always check local license first (fastest)
        if (checkAppLicensed()) {
            return $next($request);
        }
        
        // If no local license, redirect to license page
        // The license page will handle API calls with proper error handling
        return redirect()->route('license');
    }
}
