<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use function App\Helpers\submitAppLicensed;

class LicenseController extends Controller
{
    /**
     * Store a license activation
     * @param Request $request
     * @return RedirectResponse
     */
    public function store(Request $request): RedirectResponse
    {
        $request->validate([
            'licence_code' => 'required|string|size:14',
        ]);

        $result = submitAppLicensed($request->licence_code);

        if ($result['success']) {
            return redirect()->route('home')
                ->with('success', $result['message'] ?? 'Licence activée avec succès');
        } else {
            return redirect()->route('license')
                ->with('error', $result['message'] ?? 'Erreur lors de l\'activation de la licence');
        }
    }
}
